﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Karta wypłat zasiłków rodzinnych i pielęgnacyjnych</title>
		<script runat="server">
		
	class Total: IComparable {
	
		class Item: IComparable {
			readonly WypElement element;
			readonly bool rodzinny;
			public Item(WypElement element, bool rodzinny) {
				this.element = element;
				this.rodzinny = rodzinny;
			}
			public WypElement Element {
				get { return element; }
			}
			public string Rodzinny {
				get { return !rodzinny ? "" : Okres.ToString(); }
			}
			public string Pielęgnacyjny {
				get { return rodzinny ? "" : Okres.ToString(); }
			}
			YearMonth Okres {
				get { return element.Okres.To.ToYearMonth(); }
			}
			public int CompareTo(object obj) {
				if (obj==null)
					return 1;
				Item i = obj as Item;
				if (i==null)
					throw new ArgumentException();
				int res = Okres.CompareTo(i.Okres);
				if (res==0)
					res = element.Definicja.Nazwa.CompareTo(i.Element.Definicja.Nazwa);
				return res;
			}			
		}
		
		readonly Pracownik pracownik;
		readonly PracHistoria historia;
		readonly ArrayList elementy = new ArrayList();
		public Total(Pracownik pracownik, FromTo okres) {
			this.pracownik = pracownik;
			this.historia = pracownik[okres.To];
			PlaceModule pl = PlaceModule.GetInstance(pracownik);
            try {
			    foreach (WypElement e in pracownik.Elementy[okres]) {
				    switch (e.Definicja.Deklaracje.PozycjaRCA) {
				    case PozycjaRCA.ZasiłekRodzinny:
					    elementy.Add(new Item(e, true));
					    break;
				    case PozycjaRCA.ZasiłekPielęgnacyjny:
					    elementy.Add(new Item(e, false));
					    break;
				    }
			    }
            }
            catch { Msg(false); }
			
			elementy.Sort();
		}
		public Pracownik Pracownik {
			get { return pracownik; }
		}
		public PracHistoria Historia {
			get { return historia; }
		}
		public IEnumerable Elementy {
			get { return elementy; }
		}
		public bool Wchodzi {
			get { return elementy.Count>0; }
		}
		public int CompareTo(object obj) {
			if (obj==null)
				return 1;
			Total t = obj as Total;
			if (t==null)
				throw new ArgumentException();
			return pracownik.CompareTo(t.pracownik);
		}
	}
	
	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context): base(context) {
			Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
			okres = FromTo.Year(data.Year);
		}
		FromTo okres;
		[Required]
		public FromTo Okres {
			get { return okres; }
			set { 
				okres = value; 
				OnChanged(EventArgs.Empty);
			}
		}
	}	
	
	PrnParams pars; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 
	
	string nazwaOkresu;
    void OnContextLoad(Object sender, EventArgs args) {		
        report = ReportHeader1;
		if (pars.Okres == FromTo.Year(pars.Okres.From.Year))
			nazwaOkresu = pars.Okres.From.Year + " rok";
		else
			nazwaOkresu = "okres " + pars.Okres.ToString();
			
		Row[] rows = (Row[])dc[typeof(Row[])];
		ArrayList result = new ArrayList();
		foreach (Pracownik p in rows) {
			Total t = new Total(p, pars.Okres);
			if (t.Wchodzi)
				result.Add(t);
		}
		DataRepeater1.DataSource = result;
	}
	
    void OnBeforeRow(Object sender, EventArgs args) {
		Total t = (Total)DataRepeater1.CurrentRow;
        string msg = Msg(true);
		ReportHeader1.Title = string.Format("Karta wypłat zasiłków rodzinnych i pielęgnacyjnych za {0}|{1}|Urodzony: {2}|PESEL: {3}|Adres: {4}|{5}",
			nazwaOkresu,			
			t.Pracownik.NazwiskoImię, 
			t.Historia.Urodzony.Data,
			t.Historia.PESEL,
			t.Historia.Adres,
            msg);
	}
	
	public static void Msg(object obj) {
	}

    public static ReportHeader report;

    public static string Msg(bool flag) {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            if (flag)
                msg = "";
            else
                report.Title += "|" + msg;
        return msg;
    }
	
		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="KartaWypłatZasiłkówRodzinnychIPielęgnacyjnych" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row,Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" onbeforerow="OnBeforeRow" Width="100%" Height="189px">
<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak><FONT face="Tahoma">
					<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Karta wypłat zasiłków rodzinnych i pielęgnacyjnych" runat="server"></cc1:ReportHeader></FONT><BR>- 
Ustalono prawo, brak prawa* w okresie od . . . . . . . . . . . . . . . . . . . . 
do . . . . . . . . . . . . . . . . . . . .<BR>- Ustalono prawo, brak prawa* w 
okresie od . . . . . . . . . . . . . . . . . . . . do . . . . . . . . . . . . . 
. . . . . . .<BR>- Ustalono prawo, brak prawa* w okresie od . . . . . . . . . . 
. . . . . . . . . . do . . . . . . . . . . . . . . . . . . . .<BR>- Ustalono 
prawo, brak prawa* w okresie od . . . . . . . . . . . . . . . . . . . . do . . . 
. . . . . . . . . . . . . . . . .<BR><BR>* niepotrzebne skreślić<BR><BR>
<ea:Grid id="Grid1" runat="server" DataMember="Elementy">
					<Columns>
						<ea:GridColumn Width="3" Align="Right" DataMember="#" Caption="Lp."  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="30" DataMember="Element.Wyplata.ListaPlac.Numer" Caption="Nr listy płac"  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Center" DataMember="Element.Wyplata.Numer.Numer" Caption="Nr pozycji"  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Center" DataMember="Element.Wyplata.Data" Caption="Data wypłaty"  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Align="Center" DataMember="Rodzinny" Caption="Zasiłek rodzinny za"  HideZero="True"></ea:GridColumn>
						<ea:GridColumn Align="Center" DataMember="Pielęgnacyjny" Caption="Zasiłek pielęgnacyjny za"  HideZero="True"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" DataMember="Element.Wartosc" Caption="Kwota"  Format="{0:n}" NoWrap="True"></ea:GridColumn>
					</Columns>
				</ea:Grid>
<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter></ea:datarepeater>
		</form>
	</body>
</HTML>

